<?php
session_start(); 
require 'conexao.php';

// Debug: verificar dados recebidos
error_log("Dados recebidos na sessão: " . print_r($_SESSION, true));

// Verificar se as variáveis necessárias existem
if (!isset($_SESSION['situacaodef'], $_SESSION['personagemdef'], $_SESSION['soldadosdef'])) {
    die("Dados incompletos na sessão");
}

$situacaodef = $_SESSION['situacaodef'];
$personagemdef = $_SESSION['personagemdef'];
$soldadosdef = $_SESSION['soldadosdef'];

if ($situacaodef == 'caçando') {
    try {
        $nvsaldocarne = $soldadosdef;
        
        // Atualiza a carne do personagem
        $sql = "UPDATE personagens SET carne = :nvsaldocarne WHERE personagem = :personagem";
        $stmt = $pdo->prepare($sql);
        $stmt->bindParam(':nvsaldocarne', $nvsaldocarne, PDO::PARAM_INT);
        $stmt->bindParam(':personagem', $personagemdef, PDO::PARAM_STR);
       
        if ($stmt->execute()) {
            // Marca como processado para evitar loops
            $_SESSION['carne_atualizada'] = true;
            
            // Debug
            error_log("Carne atualizada para $nvsaldocarne no personagem $personagemdef");
      
            // Redireciona de volta
            header("Location: atacando.php?carne_atualizada=1");
            exit;
        } else {
            throw new Exception("Erro ao executar UPDATE: " . implode(", ", $stmt->errorInfo()));
        }
    } catch (Exception $e) {
        error_log($e->getMessage());
        die("Erro ao processar atualização de carne");
    }
} else {
    header("Location: atacando.php");
    exit;
}
?>